%define name mptlinux
%define version 4.00.43.00
%define release 1
Summary: MPT Fusion drivers for 53C1030, FC9XX, and SAS Adapters
Name: %{name}
Version: %{version}
Release: %{release}
Vendor: LSI Logic
License: GPL
Group: System Environment/Kernel
Source0: %{name}-%{version}.tar.gz
Source1: fusion.mptctl
URL: http://www.lsilogic.com
Distribution: LSI Logic
BuildRoot: /var/tmp/%{name}-buildroot
Packager: Eric Moore <Eric.Moore@lsi.com>

%description
Drivers for (suse i686, x86_64, ia64 and updates) for the
LSI Logic Fusion-MPT Architecture parts.
These include the Ultra320 53C1030 and 53C1020 adapters.
Fibre Channel FC909, FC919, FC929, FC919X, FC929X, and FC949X adapters
SAS SAS1064, SAS1068, and SAS1078 adapters.

# prep #########################################################################
%prep
echo prep %{version}
%setup -c -b 0

# build ########################################################################
%build
echo build %{version}
for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`;
	if [ -f /lib/modules/${kernel}/source/drivers/message/fusion/Kconfig ]; then
		make build KERNEL=$kernel;
	fi;
done;

# install ######################################################################
%install
echo install %{version}
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
echo "/etc/init.d/fusion.mptctl" >> $RPM_BUILD_DIR/file.list.%{name}
mkdir -p $RPM_BUILD_ROOT/etc/init.d
cp -rf $RPM_SOURCE_DIR/fusion.mptctl $RPM_BUILD_ROOT/etc/init.d
for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`
	if [ ! -e /lib/modules/${kernel}/source/drivers/message/fusion/Kconfig ]; then
		continue;
	fi;
	MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/message/fusion
	mkdir -p $RPM_BUILD_ROOT/lib/modules/${kernel}/kernel/drivers/message/fusion

	# create the file list used in %files to indicate which files are in package
	for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
		echo "$MPTLINUX_IPATH/${driver_name}.new" >> $RPM_BUILD_DIR/file.list.%{name}
	done;

	make install PREFIX=$RPM_BUILD_ROOT KERNEL=$kernel

	for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
		mv -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name} \
			$RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}.new
	done;
done;

# pre #########################################################################
%pre
echo pre %{version}
system_arch=`uname -m`
if [ -f /etc/SuSE-release ] && [ ${system_arch} == i686 ]; then
	system_arch=i586;
fi;
if [ %{_target_cpu} != ${system_arch} ]; then
	echo "ERROR: Failed installing this rpm!!!!"
	echo "This rpm is intended for %{_target_cpu} platform. It seems your system is ${system_arch}.";
	exit 1;
fi;

# post #########################################################################
%post
echo post %{version}
chkconfig fusion.mptctl --add >/dev/null 2>&1
if [ -f /etc/redhat-release ]; then
	# RHEL 4
	if [ -f /etc/modprobe.conf ] ; then
		cp /etc/modprobe.conf /etc/modprobe.conf.orig.%{version};
		sed -e '/mptbase/d' /etc/modprobe.conf > modprobe.edit;
		sed -e '/mptscsih/d' modprobe.edit > modprobe.edit.1;
		sed -e '/mptspi/d' modprobe.edit.1 > modprobe.edit.2;
		sed -e '/mptfc/d' modprobe.edit.2 > modprobe.edit.3;
		sed -e '/mptsas/d' modprobe.edit.3 > modprobe.edit;
		echo "alias scsi_hostadapter mptspi" >> modprobe.edit;
		echo "alias scsi_hostadapter1 mptfc" >> modprobe.edit;
		echo "alias scsi_hostadapter2 mptsas" >> modprobe.edit;
		mv -f modprobe.edit /etc/modprobe.conf;
		rm -fr modprobe.edit.*;
	fi;
elif [ -f /etc/SuSE-release ]; then
	# SLES 9
	if [ -f /etc/sysconfig/kernel ] ; then
		cp /etc/sysconfig/kernel /etc/sysconfig/kernel.orig.%{version};
		sed -e 's/mptscsih//g' /etc/sysconfig/kernel > kernel.edit;
		sed -e 's/mptsas//g' kernel.edit > kernel.edit.1;
		sed -e 's/mptfc//g' kernel.edit.1 > kernel.edit.2;
		sed -e 's/mptspi//g' kernel.edit.2 > kernel.edit.3;
		sed -e 's/INITRD_MODULES="/INITRD_MODULES="mptsas /g' kernel.edit.3 > kernel.edit.4;
		sed -e 's/INITRD_MODULES="/INITRD_MODULES="mptfc /g' kernel.edit.4 > kernel.edit.5;
		sed -e 's/INITRD_MODULES="/INITRD_MODULES="mptspi /g' kernel.edit.5 > kernel.edit;
		mv -f kernel.edit /etc/sysconfig/kernel;
		rm -fr kernel.edit.*;
	fi;
fi

# adding device nodes
if [ ! -e /dev/mptctl ]; then
	echo "Creating /dev/mptctl ioctl node file";
	mknod /dev/mptctl c 10 220;
fi;

for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`;
	MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/message/fusion
	if [ ! -e $MPTLINUX_IPATH/mptbase.ko ] || \
	    [ ! -e $MPTLINUX_IPATH/mptbase.ko.new ]; then
		continue;
	fi;

	if [ -f /etc/SuSE-release ] &&
	    [ ! -e /boot/initrd-${kernel} ]; then
		continue;
	fi;

	echo "The mpt driver for kernel ${kernel} is now version 4.00.43.00";
	#backup original fusion drivers here if not already done
	for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
		if [ ! -e $MPTLINUX_IPATH/${driver_name}.orig ]; then
			cp $MPTLINUX_IPATH/${driver_name} \
				$MPTLINUX_IPATH/${driver_name}.orig
		fi;
		cp -f $MPTLINUX_IPATH/${driver_name}.new $MPTLINUX_IPATH/${driver_name}
	done;
	# Remake the initrd image for the user, depending on their OS
	if [ -f /etc/redhat-release ]; then

		# taking care of dud migration, by moving all the ko's to ko.orig
		for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
			MPTLINUX_IPATH=/lib/modules/${kernel}/updates
			if [ -e $MPTLINUX_IPATH/${driver_name} ]; then
				mv $MPTLINUX_IPATH/${driver_name} \
				    $MPTLINUX_IPATH/${driver_name}.orig
			fi;
		done;

		# RHEL 4
		if [ -d /boot/efi/efi/redhat ]; then
			bootpart=/boot/efi/efi/redhat;
		elif [ -d /boot/efi ]; then
			bootpart=/boot/efi;
		else
			bootpart=/boot;
		fi
		if [ ! -e ${bootpart}/initrd-${kernel}.img.orig ]; then
			echo Saving initrd-${kernel}.img in ${bootpart} directory.
			cp ${bootpart}/initrd-${kernel}.img \
			    ${bootpart}/initrd-${kernel}.img.orig
		fi;
		# Calling depmod
		depmod -v ${kernel} > /dev/null 2>&1;
		mkinitrd -f ${bootpart}/initrd-${kernel}.img ${kernel}
	elif [ -f /etc/SuSE-release ]; then
		# SLES 9
		if [ ! -e /boot/initrd-${kernel}.orig ]; then
			echo Saving initrd-${kernel} in /boot directory.
			cp /boot/initrd-${kernel} /boot/initrd-${kernel}.orig
		fi;
		# Calling depmod
		depmod -v ${kernel} > /dev/null 2>&1;
		mk_initrd -k vmlinuz-${kernel} -i /boot/initrd-${kernel}
	fi;
done;
echo -e "post Install Done."

# postun #######################################################################
%postun
echo postun %{version}
for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`;
	MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/message/fusion
	if [ ! -e $MPTLINUX_IPATH/mptbase.ko ] || \
	    [ -e $MPTLINUX_IPATH/mptbase.ko.new ]; then
		continue;
	fi;
	if [ ! -e /etc/init.d/fusion.mptctl ]; then
		chkconfig fusion.mptctl --del >/dev/null 2>&1
	fi;
	if [ -f /etc/modprobe.conf.orig ]; then
		# RHEL 4
		mv -f /etc/modprobe.conf.orig /etc/modprobe.conf;
	elif [ -f /etc/sysconfig/kernel.orig ]; then
		# SLES 9
		mv -f /etc/sysconfig/kernel.orig /etc/sysconfig/kernel;
	fi;
	for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
		if [ -f $MPTLINUX_IPATH/${driver_name}.orig ]; then
			mv -f $MPTLINUX_IPATH/${driver_name}.orig $MPTLINUX_IPATH/${driver_name}
		fi;
	done;
	# restore original initrd images
	if [ -f /etc/redhat-release ]; then

		# restoring the state of dud migration
		for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
			MPTLINUX_IPATH=/lib/modules/${kernel}/udpates
			if [ -f $MPTLINUX_IPATH/${driver_name}.orig ]; then
				mv -f $MPTLINUX_IPATH/${driver_name}.orig $MPTLINUX_IPATH/${driver_name}
			fi;
		done;

		# RHEL 4
		if [ -d /boot/efi/efi/redhat ]; then
			bootpart=/boot/efi/efi/redhat;
		elif [ -d /boot/efi ]; then
			bootpart=/boot/efi;
		else
			bootpart=/boot;
		fi
		if [ -f ${bootpart}/initrd-${kernel}.img.orig ]; then
			mv -f ${bootpart}/initrd-${kernel}.img.orig ${bootpart}/initrd-${kernel}.img;
		fi;
	elif [ -f /etc/SuSE-release ]; then
		# SLES 9
		if [ -f /boot/initrd-${kernel}.orig ]; then
			mv -f /boot/initrd-${kernel}.orig /boot/initrd-${kernel};
		fi;
	fi;
	depmod -v ${kernel} > /dev/null 2>&1;
done;
echo -e "Uninstall Done."

# files ########################################################################
%files -f ../file.list.%{name}

# changelog  ###################################################################
%changelog
* Tue Apr 24 2007 Eric Moore <Eric.Moore@lsi.com>
 - Fix RHEL5 DUD to RPM migration
* Tue Apr 17 2007 Eric Moore <Eric.Moore@lsi.com>
 - Ported to work in SLES10 Build Kit
* Tue Feb 20 2007 Eric Moore <Eric.Moore@lsi.com>
 - Adding fusion.mptctl
* Fri Feb 2 2007 Eric Moore <Eric.Moore@lsi.com>
 - Ported to work in RHEL5 Build Kit
* Wed May 18 2005 Eric Moore <Eric.Moore@lsi.com>
 -Adding support for compiling drivers for mulitple kernels.
 -Adding split driver support
