# If one of the modules in this package is in the initrd,
# we need to recreate the initrd.
VAR=`uname -r`
RAMDISK=NULL
DEVICE_NODE=/dev/mptctl

if [ -e /etc/sysconfig/kernel -a -f /etc/fstab ]; then
    source /etc/sysconfig/kernel
    run_mkinitrd=
    for module in $INITRD_MODULES; do
	case " $MODULES " in
	*" $module "*)
	    run_mkinitrd=1
	    break ;;
	esac
    done
    if [ -n "$run_mkinitrd" ]; then
	    for image in vmlinuz image vmlinux linux bzImage; do
		if [ -f /boot/$image-${VAR} ]; then
		    /sbin/mkinitrd -k /boot/$image-${VAR} \
		   -i /boot/initrd-${VAR}.update \
		    || exit 1
       echo " Created initrd image: initrd-${VAR} ! "
     RAMDISK=initrd-${VAR}.update
		fi
	    done
    fi
# Create device node for mptctl
    if [ -f /boot/$RAMDISK ]; then
	echo " Check for  mptctl device node !"
	if  [ -e  $DEVICE_NODE ]; then
		echo " Device node $DEVICE_NODE already exists !"
	else
		echo " Creating device node $DEVICE_NODE for mptctl !"
  		mknod $DEVICE_NODE c 10 220;
	fi
    fi
fi
