#
# spec file for package lsi-mptlinux (MPT FUSION Driver package)
#
# Copyright (c) 2007 Novell, Inc.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://support.novell.com
#

# neededforbuild  kernel-source kernel-syms

BuildRequires:  aaa_base acl attr bash bind-utils bison bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db devs diffutils e2fsprogs file filesystem fillup findutils flex gawk gdbm-devel glibc glibc-devel glibc-locale gpm grep groff gzip info insserv kbd less libacl libattr libgcc libselinux libstdc++ libxcrypt m4 make man mktemp module-init-tools ncurses ncurses-devel net-tools netcfg openldap2-client openssl pam pam-modules patch permissions popt procinfo procps psmisc pwdutils rcs readline sed strace syslogd sysvinit tar tcpd texinfo timezone unzip util-linux vim zlib zlib-devel autoconf automake binutils gcc gdbm gettext kernel-source kernel-syms libtool perl rpm
%define version 3.13.04.00
%define dversion 3.13.04.00
%define release 1 

Name:           lsi-mptlinux
%define driver_name mptlinux
%define driver_version %{version}
%define kver 2.6.5-7.191
%define sp_kver 2.6.5_7.191

%define arch %(echo %_target_cpu | sed -e 's/i.86/i386/' -e 's/s390x/s390/')
License:        GNU General Public License (GPL)
Group:          System/Kernel
Autoreqprov:    on
Summary:        mptlinux driver KMP Package
Version:        %{version}_%{sp_kver}
Release:        %{release}
Requires:       kernel = %kver
Source0:        %{driver_name}-%{dversion}-src.tar.gz
Source1:        depmod.sh
Source2:        mkinitrd.sh
Source3:        updatemenulst.sh
Source4:        uninstall.sh
Source5:        Module.supported
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
This package contains the mptlinux driver modules wrapped for the KMP
framework.



%prep
# Make sure to include a %setup statement in the %prep section:
# without, the ``%post -f ...'' and ``%postun -f ...'' statements
# will silently fail and produce empty scripts.
#%setup -n %driver_name-%driver_version
%setup -n message/fusion/
cp %_sourcedir/Module.supported Module.supported
mkdir source
mv * source/ || :
mkdir obj

%build
export EXTRA_CFLAGS='-DVERSION=\"%driver_version\"'
flavors=$(ls /usr/src/linux-obj/%arch)
# add other flavors to skip if needed.
for flavor in $flavors; do
    if [ $flavor = um ]; then
	# User Mode Linux is an exception for many external kernel modules;
	# we may choose to skip it here.
	continue
    fi
    rm -rf obj-$flavor
    cp -r source obj/$flavor
    make -C /usr/src/linux-obj/%arch/$flavor modules M=$PWD/obj/$flavor
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in $(ls obj/); do
    make -C /usr/src/linux-obj/%arch/$flavor modules_install \
	M=$PWD/obj/$flavor
done
set -- $(ls $RPM_BUILD_ROOT/lib/modules)
KERNELRELEASES=$*
set -- $(find $RPM_BUILD_ROOT/lib/modules -type f -name '*.ko' \
	 | sed -e 's:.*/::' -e 's:\.ko$::' | sort -u)
MODULES=$*
(   cat <<-EOF
	# IMPORTANT: Do not change the KERNELRELEASES definition; it will be
	# replaced during driver reuse!
	KERNELRELEASES="$KERNELRELEASES"
	MODULES="$MODULES"
	EOF
    cat %_sourcedir/depmod.sh
    cat %_sourcedir/mkinitrd.sh
    cat %_sourcedir/updatemenulst.sh
) > post_install.sh
cat %_sourcedir/uninstall.sh >post_uninstall.sh
mkdir -p $RPM_BUILD_ROOT/var/lib/YaST2/download
# Insert your download location here:
echo "http://forgeftp.novell.com/driver-process/pub/update/LSI/sle9/common;SUSE/Novell" \
    > $RPM_BUILD_ROOT/var/lib/YaST2/download/%name

%post -f post_install.sh


%postun -f post_uninstall.sh

%files
%defattr(-, root, root)
/lib/modules/*
%dir /var/lib/YaST2
%dir /var/lib/YaST2/download
%config(noreplace) /var/lib/YaST2/download/%name

%changelog
* Tue Jun 19 2007 - divyanshu.verma@novell.com
- Initial Version
