#!/bin/bash

VAR=`uname -r`
BOOTFILE=/boot/grub/menu.lst
grep "initrd-${VAR}.update" -w $BOOTFILE 2>&1 1>/dev/null 
if [ $? == 0 ];then
		echo "initrd-${VAR}.update entry is already present no need to update $BOOTFILE! "
else
	echo "Entry for initrd-${VAR} is not present, updating $BOOTFILE"
	sed --in-place=.orig $BOOTFILE -e "s/boot\/initrd-${VAR}/boot\/initrd-${VAR}.update/g"
	echo "$BOOTFILE has been successfully updated to have entry for initrd-${VAR}.update"
fi
echo "Install successfully completed #######"
exit 0
