#!/bin/sh

# main
SUM=$1
KERNEL=$2
BUILD_PATH=$3
UPDATE_FILE=$4
DRIVER_PATH=kernel/drivers/message/fusion
update_file=/etc/sysconfig/kernel
VERSION=`echo ${KERNEL} | cut -f2 -d "-"`
found_kernel=no
is_boot=no

# uncomment following line for debugging
#set -x

if [ "${SUM}" = "no_md5sum_required" ]; then
	BOOT_KERNEL=${KERNEL};
	found_kernel=yes;
else
	BOOT_KERNEL=`echo ${KERNEL} | sed -e 's/'-"$VERSION"'//'`
	# MD5SUM Check and make sure we are booting to the same kernel
	if [ -e "/boot/vmlinuz" ]; then
		kernel_md5sum=`md5sum /boot/vmlinuz | awk '{print $1}'`
		if [ ${kernel_md5sum} = ${SUM} -a \
		     `grep -c ${BOOT_KERNEL} /proc/version` -gt 0 ]; then
			found_kernel=yes;
		fi;
	fi;
	if [ -e "/boot/vmlinuz-${KERNEL}" ]; then
		kernel_md5sum=`md5sum /boot/vmlinuz-${KERNEL} | awk '{print $1}'`
		BOOT_KERNEL=${KERNEL};
		if [ ${kernel_md5sum} = ${SUM} -a \
		     `grep -c ${BOOT_KERNEL} /proc/version` -gt 0 ]; then
			found_kernel=yes;
		fi;
	fi;
fi;
if [ "${found_kernel}" = "yes" ]; then
	echo -e "Detected ${KERNEL} kernel.";
	if [ ! -e /dev/mptctl ]; then
		echo -e "Creating /dev/mptctl ioctl node file";
		mknod /dev/mptctl c 10 220;
	fi;
	#Copy files up to /lib/modules
	if [ -d "${BUILD_PATH}"/"${KERNEL}" ] ; then
		echo -e "Copying Fusion-MPT binaries to /lib/modules/${BOOT_KERNEL}/${DRIVER_PATH}"
		cp -f ${BUILD_PATH}/${KERNEL}/${DRIVER_PATH}/* /lib/modules/${BOOT_KERNEL}/${DRIVER_PATH}/
		echo ${BOOT_KERNEL} >> ${UPDATE_FILE}
	else
		echo -e "WARNING: No Fusion-MPT binary update for ${KERNEL} kernel."
		exit 1;
	fi;
	# Find out if RAMDISK needs updating
	if [ -e /etc/rc.config ]; then
		if [ `grep -c "mptbase" /etc/rc.config` -gt 0 ]; then
			is_boot=yes;
		fi;
	fi;
	if [ -e /etc/sysconfig/kernel ]; then
		if [ `grep -c "mptscsih" /etc/sysconfig/kernel` -gt 0 ]; then
			is_boot=yes;
		# is /proc/folder been created ??
		else
			if [ -d "/proc/mpt/ioc0" ]; then
				sed 's/INITRD_MODULES="/INITRD_MODULES="mptscsih /' ${update_file} > ${update_file}.001 ;
				mv ${update_file}.001 ${update_file} ;
				is_boot=yes;
			else
				# try loading the driver
				insmod /lib/modules/`uname -r`/kernel/drivers/message/fusion/mptbase.ko >/dev/null 2>&1 ;
				# is /proc/folder been created ??
				if [ -d "/proc/mpt/ioc0" ]; then
					sed 's/INITRD_MODULES="/INITRD_MODULES="mptscsih /' ${update_file} > ${update_file}.001 ;
					mv ${update_file}.001 ${update_file} ;
					is_boot=yes;
				fi;
				rmmod mptbase >/dev/null 2>&1 ;
			fi;
		fi;
	fi;
	bootpart=boot;
	if [ "${is_boot}" = "yes" ]; then
		echo -e "Updating ramdisk image with Fusion-MPT binary drivers."
		if [ -e /${bootpart}/initrd ]; then
			echo -e "Saving initrd in initrd.orig";
			mv /${bootpart}/initrd /${bootpart}/initrd.orig;
		fi;
		if [ -e /${bootpart}/initrd.shipped ]; then
			echo -e "Saving initrd.shipped in initrd.shipped.orig";
			mv /${bootpart}/initrd.shipped /${bootpart}/initrd.shipped.orig;
		fi;
		if [ -e /${bootpart}/initrd.suse ]; then
			echo -e "Saving initrd.suse in initrd.suse.orig";
			mv /${bootpart}/initrd.suse /${bootpart}/initrd.suse.orig;
		fi;
		echo -e "Creating ramdisk images................";
		/sbin/mk_initrd >/dev/null 2>&1;
		echo -e "\nIMPORTANT: /"${bootpart} " has been modified!";
		echo -e "If LILO is your boot loader, please re-run /sbin/lilo.";
		echo -e "You must reboot for the change to take effect.";
	else
		echo -e "WARNING: ramdisk image in /"${bootpart} " was not modified!";
	fi;
else
	echo -e "WARNING: No Fusion-MPT binary update for ${KERNEL} kernel.";
fi;
