%define name mptlinux
%define version 2.06.71.00
%define release 1
Summary: MPT Fusion drivers for 53C1030, FC9XX, and SAS Adapters
Name: %{name}
Version: %{version}
Release: %{release}
Vendor: LSI Logic
Copyright: LSI Logic Corporation
Group: System Environment/Kernel
Source: %{name}-%{version}.tar.gz
URL: http://www.lsilogic.com
Distribution: LSI Logic
BuildRoot: /var/tmp/%{name}-buildroot
Packager: Eric Moore <Eric.Moore@lsil.com>

%description
Drivers for (suse i686, x86_64, ia64 and updates) for the
LSI Logic Fusion-MPT Architecture parts.
These include the Ultra320 53C1030, 53C1020 and the Fiber
Channel FC909, FC919, FC929, FC919X and FC929X adapters.
SAS1064, SAS1066, and SAS1068 adapters.

%prep
echo
echo "prep script executing"
echo
%setup -c -b 0

%build
echo
echo "build script executing"
echo
make all

%install
echo
echo "install script executing"
echo
echo $RPM_BUILD_ROOT

MPTLINUX_IPATH=/lib/modules/`uname -r`/kernel/drivers/message/fusion

mkdir -p $RPM_BUILD_ROOT/lib/modules/`uname -r`/kernel/drivers/message/fusion

# create the file list used in %files to indicate which files are in package

echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}

for driver_name in mptbase.o mptscsih.o mptctl.o mptlan.o; do
echo "$MPTLINUX_IPATH/${driver_name}.new" >> $RPM_BUILD_DIR/file.list.%{name}
done

make install PREFIX=$RPM_BUILD_ROOT

for driver_name in mptbase.o mptscsih.o mptctl.o mptlan.o; do
mv -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name} \
	$RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}.new
done

%post
echo
echo "post script executing"
echo
echo "RPM build root:"
echo $RPM_BUILD_ROOT
echo

MPTLINUX_IPATH=/lib/modules/`uname -r`/kernel/drivers/message/fusion

#backup original fusion drivers here if not already done
for driver_name in mptbase.o mptscsih.o mptctl.o mptlan.o; do
mv -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name} \
      $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}.orig.%{release}
cp -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}.new \
      $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}
done

# Remake the initrd image for the user, depending on their OS
if [ -f /etc/redhat-release ]
then
# RHEL 3 and 4

  if [ -f /etc/modules.conf ];
  then
  # For RHEL 3
    if [ `grep -c "mptscsih" /etc/modules.conf` -eq 0 ];
    then
      echo "Editing modules.conf file";
      echo "alias scsi_hostadapter mptbase" >> /etc/modules.conf;
      echo "alias scsi_hostadapter1 mptscsih" >> /etc/modules.conf;
    fi;
  elif [ -f /etc/modprobe.conf ];
  then
  # For RHEL 4
    if [ `grep -c "mptscsih" /etc/modprobe.conf` -eq 0 ];
    then
      echo "Editing modprobe.conf file";
      echo "alias scsi_hostadapter mptbase" >> /etc/modprobe.conf;
      echo "alias scsi_hostadapter1 mptscsih" >> /etc/modprobe.conf;
    fi;
  fi;

  cp /boot/initrd-`uname -r`.img /boot/initrd-`uname -r`.img.orig
  mkinitrd -f /boot/initrd-`uname -r`.img `uname -r`
  echo "initrd image created:"
  echo "  initrd-`uname -r`.img in /boot directory."
  echo "The original initrd file was copied to /boot/initrd-`uname -r`.img.orig"

elif [ -f /etc/UnitedLinux-release ]
then
# SLES 8

  if [ `grep -c "mptscsih" /etc/sysconfig/kernel` -eq 0 ];
  then
    echo "Editing /etc/sysconfig/kernel";
    sed 's/INITRD_MODULES="/INITRD_MODULES="mptscsih /' /etc/sysconfig/kernel > /etc/sysconfig/kernel.new;
    mv /etc/sysconfig/kernel.new /etc/sysconfig/kernel;
  fi;

  cp /boot/initrd /boot/initrd.img.orig
  mk_initrd -k vmlinuz -i /boot/initrd
  echo "initrd image created:"
  echo "  initrd in /boot directory."
  echo "The original initrd file was copied to /boot/initrd.img.orig"

elif [ -f /etc/SuSE-release ]
then
# SLES 9

  if [ `grep -c "mptscsih" /etc/sysconfig/kernel` -eq 0 ];
  then
    echo "Editing /etc/sysconfig/kernel";
    sed 's/INITRD_MODULES="/INITRD_MODULES="mptscsih /' /etc/sysconfig/kernel > /etc/sysconfig/kernel.new;
    mv /etc/sysconfig/kernel.new /etc/sysconfig/kernel;
  fi;

  cp /boot/initrd-`uname -r` /boot/initrd-`uname -r`.img.orig
  mk_initrd -k vmlinuz -i /boot/initrd-`uname -r`
  echo "initrd image created:"
  echo "  initrd-`uname -r` in /boot directory."
  echo "The original initrd file was copied to /boot/initrd-`uname -r`.img.orig"
fi

echo
echo "Updating dependencies - this may take awhile..."
echo
depmod -a > /dev/null 2> /dev/null

%preun
echo
echo "preun script executing"
echo

MPTLINUX_IPATH=/lib/modules/`uname -r`/kernel/drivers/message/fusion

for driver_name in mptbase.o mptscsih.o mptctl.o mptlan.o; do
if [ -f $MPTLINUX_IPATH/${driver_name}.new ]; then
      # see if .new and .o are the same
      cmp -s $MPTLINUX_IPATH/${driver_name}.new \
             $MPTLINUX_IPATH/${driver_name}
   if [ "$?" == 0 ]; then
         # if they are the same, restore old modules
         # if they aren't, other files have been installed and nothing should be done
         # rpm will handle deletion of .new files
         rm -f $MPTLINUX_IPATH/${driver_name}
         mv -f $MPTLINUX_IPATH/${driver_name}.orig.%{release} $MPTLINUX_IPATH/${driver_name}
   fi
fi
done

echo
echo "Done with preun script restoring"
echo


%postun
echo
echo "postun script executing"
echo

# restore original initrd images
if [ -f /etc/redhat-release ]
then
# RHEL 3 and 4
  if [ -f /boot/initrd-`uname -r`.img.orig ];
  then
    echo "Removing current initrd image file and restoring original one"
    rm -f /boot/initrd-`uname -r`.img;
    mv /boot/initrd-`uname -r`.img.orig /boot/initrd-`uname -r`.img
  fi;
elif [ -f /etc/UnitedLinux-release ]
then
# SLES 8
  if [ -f /boot/initrd.img.orig ];
  then
    echo "Removing current initrd image file and restoring original one"
    rm -f /boot/initrd;
    mv /boot/initrd.img.orig /boot/initrd;
  fi;
elif [ -f /etc/SuSE-release ]
then
# SLES 9
  if [ -f /boot/initrd-`uname -r`.img.orig ];
  then
    echo "Removing current initrd image file and restoring original one"
    rm -f /boot/initrd-`uname -r`;
    mv /boot/initrd-`uname -r`.img.orig /boot/initrd-`uname -r`;
  fi;
fi;

echo
echo "Updating dependencies - this may take awhile..."
echo

depmod -a > /dev/null 2> /dev/null
exit 0

%clean
echo
echo "clean script executing"
echo

%files -f ../file.list.%{name}

%changelog
